using System;
using System.Data;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;
using System.Text.RegularExpressions;
using System.Text;

using gov.va.med.vbecs.DAL.VAL;
using gov.va.med.vbecs.Common;

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class DlgSelectLabTest
	/// </summary>
	public class DlgSelectLabTest : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		DataTable _labTests;
		DataTable _labTestsSelected;
		bool _multiSelect;
		Common.ReportType _reportType;
		Regex _thirtyTwoDigits = new Regex("^[0-9]{32,}");
		//
		private System.Windows.Forms.GroupBox grpSearch;
		private System.Windows.Forms.Label lblSearchString;
		private System.Windows.Forms.TextBox txtSearchString;
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.PictureBox pictureBox1;
		private System.Windows.Forms.GroupBox grpResults;
		private System.Windows.Forms.ColumnHeader colLabTestName;
		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.ListView lvLabTests;
		private System.Windows.Forms.ColumnHeader colSpecimen;
		private System.Windows.Forms.ColumnHeader columnHeader1;
		private System.Windows.Forms.Timer timer1;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnSearch;
		private System.Windows.Forms.ColumnHeader colIEN;
		private System.ComponentModel.IContainer components = null;

		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="allowMultiSelection"></param>
		/// <param name="reportType"></param>
		public DlgSelectLabTest(bool allowMultiSelection, Common.ReportType reportType)
		{
			// This call is required by the Windows Form Designer.
			InitializeComponent();
			//
			this._multiSelect = allowMultiSelection;
			this._reportType = reportType;
			this._labTestsSelected = BOL.LabTest.GetSpecimenTestThresholdTableSchema();
			//
			this.vbecsLogo1.Title = this.Text.Replace("VBECS - ","");
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC033.DlgSelectLabTest());
			this.btnOK.Text = "&OK";
			this.btnOK.EnabledButton = false;
			this.btnSearch.Text = "&Search";
			this.btnSearch.EnabledButton = false;
			//
			this.SetToolTips();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(DlgSelectLabTest));
			this.grpSearch = new System.Windows.Forms.GroupBox();
			this.txtSearchString = new System.Windows.Forms.TextBox();
			this.lblSearchString = new System.Windows.Forms.Label();
			this.btnSearch = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.grpImage = new System.Windows.Forms.GroupBox();
			this.pictureBox1 = new System.Windows.Forms.PictureBox();
			this.grpResults = new System.Windows.Forms.GroupBox();
			this.lvLabTests = new System.Windows.Forms.ListView();
			this.columnHeader1 = new System.Windows.Forms.ColumnHeader();
			this.colLabTestName = new System.Windows.Forms.ColumnHeader();
			this.colIEN = new System.Windows.Forms.ColumnHeader();
			this.colSpecimen = new System.Windows.Forms.ColumnHeader();
			this.btnCancel = new System.Windows.Forms.Button();
			this.timer1 = new System.Windows.Forms.Timer(this.components);
			this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.grpSearch.SuspendLayout();
			this.grpImage.SuspendLayout();
			this.grpResults.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(472, 30);
			this.vbecsLogo1.Title = "Select Lab Test";
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 345);
			this.lblRequiredField.Name = "lblRequiredField";
			// 
			// grpSearch
			// 
			this.grpSearch.AccessibleDescription = "Search Criterion ";
			this.grpSearch.AccessibleName = "Search Criterion ";
			this.grpSearch.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpSearch.Controls.Add(this.txtSearchString);
			this.grpSearch.Controls.Add(this.lblSearchString);
			this.grpSearch.Controls.Add(this.btnSearch);
			this.grpSearch.Location = new System.Drawing.Point(64, 32);
			this.grpSearch.Name = "grpSearch";
			this.grpSearch.Size = new System.Drawing.Size(404, 44);
			this.grpSearch.TabIndex = 0;
			this.grpSearch.TabStop = false;
			this.grpSearch.Text = "Search Criterion";
			// 
			// txtSearchString
			// 
			this.txtSearchString.AccessibleDescription = "Partial Lab Test Name";
			this.txtSearchString.AccessibleName = "Partial Lab Test Name";
			this.txtSearchString.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtSearchString.Location = new System.Drawing.Point(128, 16);
			this.txtSearchString.MaxLength = 50;
			this.txtSearchString.Name = "txtSearchString";
			this.txtSearchString.Size = new System.Drawing.Size(192, 20);
			this.txtSearchString.TabIndex = 0;
			this.txtSearchString.Text = "";
			this.txtSearchString.TextChanged += new System.EventHandler(this.txtSearchString_TextChanged);
			// 
			// lblSearchString
			// 
			this.lblSearchString.Location = new System.Drawing.Point(8, 16);
			this.lblSearchString.Name = "lblSearchString";
			this.lblSearchString.Size = new System.Drawing.Size(124, 20);
			this.lblSearchString.TabIndex = 31;
			this.lblSearchString.Text = "Partial Lab Test Name*";
			this.lblSearchString.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// btnSearch
			// 
			this.btnSearch.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.btnSearch.EnabledButton = false;
			this.btnSearch.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnSearch.Image = ((System.Drawing.Image)(resources.GetObject("btnSearch.Image")));
			this.btnSearch.Location = new System.Drawing.Point(320, 14);
			this.btnSearch.Name = "btnSearch";
			this.btnSearch.Size = new System.Drawing.Size(75, 23);
			this.btnSearch.TabIndex = 1;
			this.btnSearch.Click += new System.EventHandler(this.btnSearch_Click);
			this.btnSearch.MouseHover += new System.EventHandler(this.btnSearch_MouseHover);
			// 
			// grpImage
			// 
			this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpImage.BackColor = System.Drawing.SystemColors.Control;
			this.grpImage.Controls.Add(this.pictureBox1);
			this.grpImage.Location = new System.Drawing.Point(4, 32);
			this.grpImage.Name = "grpImage";
			this.grpImage.Size = new System.Drawing.Size(56, 300);
			this.grpImage.TabIndex = 45;
			this.grpImage.TabStop = false;
			// 
			// pictureBox1
			// 
			this.pictureBox1.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox1.Image")));
			this.pictureBox1.Location = new System.Drawing.Point(6, 12);
			this.pictureBox1.Name = "pictureBox1";
			this.pictureBox1.Size = new System.Drawing.Size(45, 45);
			this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.pictureBox1.TabIndex = 38;
			this.pictureBox1.TabStop = false;
			// 
			// grpResults
			// 
			this.grpResults.AccessibleDescription = "Search Results";
			this.grpResults.AccessibleName = "Search Results";
			this.grpResults.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpResults.Controls.Add(this.lvLabTests);
			this.grpResults.Location = new System.Drawing.Point(64, 76);
			this.grpResults.Name = "grpResults";
			this.grpResults.Size = new System.Drawing.Size(404, 256);
			this.grpResults.TabIndex = 1;
			this.grpResults.TabStop = false;
			this.grpResults.Text = "Search Results";
			// 
			// lvLabTests
			// 
			this.lvLabTests.AccessibleDescription = "Lab Tests";
			this.lvLabTests.AccessibleName = "Lab Tests";
			this.lvLabTests.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lvLabTests.CheckBoxes = true;
			this.lvLabTests.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																						 this.columnHeader1,
																						 this.colLabTestName,
																						 this.colIEN,
																						 this.colSpecimen});
			this.lvLabTests.FullRowSelect = true;
			this.lvLabTests.HideSelection = false;
			this.lvLabTests.Location = new System.Drawing.Point(8, 16);
			this.lvLabTests.MultiSelect = false;
			this.lvLabTests.Name = "lvLabTests";
			this.lvLabTests.Size = new System.Drawing.Size(390, 232);
			this.lvLabTests.TabIndex = 0;
			this.lvLabTests.View = System.Windows.Forms.View.Details;
			this.lvLabTests.ColumnClick += new System.Windows.Forms.ColumnClickEventHandler(this.lvLabTests_ColumnClick);
			this.lvLabTests.SelectedIndexChanged += new System.EventHandler(this.lvLabTests_SelectedIndexChanged);
			this.lvLabTests.ItemCheck += new System.Windows.Forms.ItemCheckEventHandler(this.lvLabTests_ItemCheck);
			// 
			// columnHeader1
			// 
			this.columnHeader1.Text = "Select";
			this.columnHeader1.Width = 45;
			// 
			// colLabTestName
			// 
			this.colLabTestName.Text = "Lab Test Name";
			this.colLabTestName.Width = 200;
			// 
			// colIEN
			// 
			this.colIEN.Text = "IEN";
			this.colIEN.Width = 40;
			// 
			// colSpecimen
			// 
			this.colSpecimen.Text = "Specimen Type";
			this.colSpecimen.Width = 100;
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.btnCancel.Location = new System.Drawing.Point(392, 336);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 3;
			this.btnCancel.Text = "&Cancel";
			// 
			// timer1
			// 
			this.timer1.Interval = 1500;
			this.timer1.Tick += new System.EventHandler(this.btnSearch_Click);
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.btnOK.EnabledButton = false;
			this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnOK.Image = ((System.Drawing.Image)(resources.GetObject("btnOK.Image")));
			this.btnOK.Location = new System.Drawing.Point(312, 336);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(75, 23);
			this.btnOK.TabIndex = 2;
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			this.btnOK.MouseHover += new System.EventHandler(this.btnOK_MouseHover);
			// 
			// DlgSelectLabTest
			// 
			this.AcceptButton = this.btnSearch;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(472, 361);
			this.Controls.Add(this.btnOK);
			this.Controls.Add(this.grpSearch);
			this.Controls.Add(this.grpImage);
			this.Controls.Add(this.grpResults);
			this.Controls.Add(this.btnCancel);
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.Name = "DlgSelectLabTest";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Select Lab Test";
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.grpResults, 0);
			this.Controls.SetChildIndex(this.grpImage, 0);
			this.Controls.SetChildIndex(this.grpSearch, 0);
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.grpSearch.ResumeLayout(false);
			this.grpImage.ResumeLayout(false);
			this.grpResults.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// Get SelectedLabTests
		/// </summary>
		public DataTable SelectedLabTests
		{
			get
			{
				return _labTestsSelected;
			}
		}

		/// <summary>
		/// Get AllowMultiSelection
		/// </summary>
		public bool AllowMultiSelection
		{
			get
			{
				return _multiSelect;
			}
		}

		private void SetToolTips()
		{
			this.SetThisToolTip(this.txtSearchString, Common.StrRes.Tooltips.UC033.PartialLabTestName());
			this.SetThisToolTip(this.lvLabTests, Common.StrRes.Tooltips.Common.SearchResults("lab tests"));
			//
			this.ttToolTip.SetToolTip(btnCancel,Common.StrRes.Tooltips.Common.ClickToDisregardChangesAndReturn().ResString);
		}

		private void btnSearch_Click(object sender, System.EventArgs e)
		{
			timer1.Enabled = false;

			using( new WaitCursor() )
			{
				if( !VistALink.EnsureAvailability() )
				{
					this.DialogResult = DialogResult.Cancel;
					this.Close();
					return;
				}
				//
				string searchString = this.txtSearchString.Text.Trim();
				//
				//if it starts with 32 digits it will crash the RPC, so truncate!
				if ((searchString.Length>31)&&(_thirtyTwoDigits.IsMatch(searchString)))
				{
					searchString = searchString.Substring(0,31);
				}
				//
				_labTests = BOL.LabTest.GetVistALabTests( searchString );

				if( _labTests.Rows.Count > 0 )
					LoadSearchResults();

				// Can't use else, results may have been returned that we didn't display
				if ( this.lvLabTests.Items.Count == 0 )
					DisableSearchResults();
			}
		}

		private void txtSearchString_TextChanged(object sender, System.EventArgs e)
		{
			// Reset timer
			timer1.Enabled = false;

			bool _searchStringIsNotEmpty = ( this.txtSearchString.Text.Trim().Length > 0 );

			this.btnSearch.EnabledButton = _searchStringIsNotEmpty;
			timer1.Enabled = _searchStringIsNotEmpty;
		}

		private void LoadSearchResults()
		{
			this.lvLabTests.Items.Clear();
			this.lvLabTests.CheckBoxes = true;

			DataRow[] drSorted = _labTests.Select("",Common.DatabaseConstants.VistALinkColumnNames.Name);
			//
			foreach (DataRow dr in drSorted)
			{
				if( Common.Utility.GetSpecimenTypeFromString(dr[Common.DatabaseConstants.VistALinkColumnNames.Specimen].ToString()) == Common.SpecimenType.Unknown )
					continue;

				ListViewItem lvi = new ListViewItem();
				lvi.Tag = dr;
				lvi.SubItems.Add(dr[Common.DatabaseConstants.VistALinkColumnNames.Name].ToString().Trim());
				lvi.SubItems.Add(dr[Common.DatabaseConstants.VistALinkColumnNames.IEN].ToString());
				lvi.SubItems.Add(dr[Common.DatabaseConstants.VistALinkColumnNames.Specimen].ToString());
				this.lvLabTests.Items.Add(lvi);
			}

			controls.VbecsFunction.SetColumnWidths(this.lvLabTests);
		}

		private void DisableSearchResults()
		{
			this.lvLabTests.Items.Clear();
			this.lvLabTests.CheckBoxes = false;
			this.lvLabTests.Items.Add(new ListViewItem("No matching entries"));	
			//
			controls.VbecsFunction.SetColumnWidths(this.lvLabTests);
		}

		private void lvLabTests_ItemCheck(object sender, System.Windows.Forms.ItemCheckEventArgs e)
		{
			DataRow dr = (DataRow)lvLabTests.Items[e.Index].Tag;
			DataRow drSelected = _labTestsSelected.NewRow();
			if (e.NewValue==CheckState.Checked)
			{
				if (!this._multiSelect)
				{
					//Uncheck existing rows first
					foreach(ListViewItem lvi in this.lvLabTests.CheckedItems)
					{
						lvi.Checked = false;
					}
				}
				else
				{
					//Only allow one entry to be checked per IEN
					foreach(ListViewItem lvi in this.lvLabTests.CheckedItems)
					{
						if (lvi.SubItems[2].Text == this.lvLabTests.Items[e.Index].SubItems[2].Text)
						{
							lvi.Checked = false;
						}
					}
				}
				//
				drSelected[Common.VbecsTables.SpecimenTestThreshold.SpecimenTestThresholdGuid] = Guid.NewGuid();
				drSelected[Common.VbecsTables.SpecimenTestThreshold.LabTestId] = Convert.ToInt32(dr[Common.DatabaseConstants.VistALinkColumnNames.IEN]);
				drSelected[Common.VbecsTables.SpecimenTestThreshold.VistaLaboratoryTestName] = dr[Common.DatabaseConstants.VistALinkColumnNames.Name];
				drSelected[Common.VbecsTables.SpecimenTestThreshold.SpecimenTypeCode] = Common.Utility.GetSpecimenTypeFromString(dr[Common.DatabaseConstants.VistALinkColumnNames.Specimen].ToString()).ToString().Substring(0,1);
				drSelected[Common.VbecsTables.SpecimenTestThreshold.ReportTypeId] = (int)this._reportType;
				drSelected[Common.VbecsTables.SpecimenTestThreshold.RecordStatusCode] = Common.Utility.GetRecordStatusCodeCharFromEnum(Common.RecordStatusCode.Active);
				drSelected[Common.VbecsTables.SpecimenTestThreshold.DivisionCode] = LogonUser.LogonUserDivisionCode;
				drSelected[Common.VbecsTables.SpecimenTestThreshold.LastUpdateUser] = ThisUser.UserNTLoginID;
				//
				if (_labTestsSelected.Select(Common.VbecsTables.SpecimenTestThreshold.LabTestId + " = '"+dr[Common.DatabaseConstants.VistALinkColumnNames.IEN]+"'").Length<1) 
				{
					_labTestsSelected.Rows.Add(drSelected);
				}
			}
			else
			{
				if (_labTestsSelected.Select(Common.VbecsTables.SpecimenTestThreshold.LabTestId + " = '"+dr[Common.DatabaseConstants.VistALinkColumnNames.IEN]+"'").Length>0) 
				{
					DataRow rmDr = _labTestsSelected.Select(Common.VbecsTables.SpecimenTestThreshold.LabTestId + " = '"+dr[Common.DatabaseConstants.VistALinkColumnNames.IEN]+"'")[0];
					_labTestsSelected.Rows.Remove(rmDr);
				}
			}
			this.btnOK.EnabledButton = (_labTestsSelected.Rows.Count>0);
		}

		private void btnOK_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		private void lvLabTests_ColumnClick(object sender, System.Windows.Forms.ColumnClickEventArgs e)
		{
			if (e.Column == 2)
			{
				controls.ColumnClickSorter.ColumnClickHandler(sender, e, lvLabTests.CheckBoxes, controls.ColumnClickSorter.ColumnSortType.Integer);
			}
			else
			{
				controls.ColumnClickSorter.ColumnClickHandler(sender, e, lvLabTests.CheckBoxes, controls.ColumnClickSorter.ColumnSortType.String);
			}
		}

		private void btnOK_MouseHover(object sender, System.EventArgs e)
		{
			if (this.btnOK.EnabledButton)
			{
				this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.OKToContinue().ResString);
			}
			else
			{
				this.btnOK.SetToolTip(Common.StrRes.Tooltips.UC033.SelectLabTest().ResString);
			}
		}

		private void btnSearch_MouseHover(object sender, System.EventArgs e)
		{
			if (this.btnSearch.EnabledButton)
			{
				this.btnSearch.SetToolTip(Common.StrRes.Tooltips.UC033.ClickSearch().ResString);
			}
			else
			{
				this.btnSearch.SetToolTip(Common.StrRes.Tooltips.UC033.EnterSearchString().ResString);
			}		
		}

		private void lvLabTests_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			this.SpeakListViewWithCheckBox(lvLabTests);
		}

	}
}

